<!DOCTYPE html>
<html>
<head lang="en">
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="description" content="Metro, a sleek, intuitive, and powerful framework for faster and easier web development for Windows Metro Style.">
    <meta name="keywords" content="HTML, CSS, JS, JavaScript, framework, metro, front-end, frontend, web development">
    <meta name="author" content="Sergey Pimenov and Metro UI CSS contributors">

    <link rel='shortcut icon' type='docs/image/x-icon' href='../favicon.ico' />
    <title>Tiles examples :: Start Screen :: Metro UI CSS - The front-end framework for developing projects on the web in Windows Metro Style</title>

    <link href="docs/css/metro.css" rel="stylesheet">
    <link href="docs/css/metro-icons.css" rel="stylesheet">

    <script src="docs/js/jquery-2.1.3.min.js"></script>
    <script src="docs/js/metro.js"></script>

    <style>
        .tile-area-controls {
            position: fixed;
            right: 40px;
            top: 40px;
        }

        .tile-group {
            left: 100px;
        }

        .tile, .tile-small, .tile-sqaure, .tile-wide, .tile-large, .tile-big, .tile-super {
            opacity: 0;
            -webkit-transform: scale(.8);
            transform: scale(.8);
        }

        .charm.right-side {
            width: 300px;
            right: -300px;
        }

        #charmSettings .button {
            margin: 5px;
        }

        @media screen and (max-width: 640px) {
            .tile-area {
                overflow-y: scroll;
            }
            .tile-area-controls {
                display: none;
            }
        }

        @media screen and (max-width: 320px) {
            .tile-area {
                overflow-y: scroll;
            }

            .tile-area-controls {
                display: none;
            }

        }
    </style>

    <script>

        /*
         * Do not use this is a google analytics fro Metro UI CSS
         * */
        if (window.location.hostname !== 'localhost') {

            (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
                (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
                    m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
            })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

            ga('create', 'UA-58849249-3', 'auto');
            ga('send', 'pageview');

        }

    </script>

    <script>
        (function($) {
            $.StartScreen = function(){
                var plugin = this;
                var width = (window.innerWidth > 0) ? window.innerWidth : screen.width;

                plugin.init = function(){
                    setTilesAreaSize();
                    if (width > 640) addMouseWheel();
                };

                var setTilesAreaSize = function(){
                    var groups = $(".tile-group");
                    var tileAreaWidth = 80;
                    $.each(groups, function(i, t){
                        if (width <= 640) {
                            tileAreaWidth = width;
                        } else {
                            tileAreaWidth += $(t).outerWidth() + 80;
                        }
                    });
                    $(".tile-area").css({
                        width: tileAreaWidth
                    });
                };

                var addMouseWheel = function (){
                    $("body").mousewheel(function(event, delta, deltaX, deltaY){
                        var page = $(document);
                        var scroll_value = delta * 50;
                        page.scrollLeft(page.scrollLeft() - scroll_value);
                        return false;
                    });
                };

                plugin.init();
            }
        })(jQuery);

        $(function(){
            $.StartScreen();

            var tiles = $(".tile, .tile-small, .tile-sqaure, .tile-wide, .tile-large, .tile-big, .tile-super");

            $.each(tiles, function(){
                var tile = $(this);
                setTimeout(function(){
                    tile.css({
                        opacity: 1,
                        "-webkit-transform": "scale(1)",
                        "transform": "scale(1)",
                        "-webkit-transition": ".3s",
                        "transition": ".3s"
                    });
                }, Math.floor(Math.random()*500));
            });

            $(".tile-group").animate({
                left: 0
            });
        });
        function showSearch(){
            var  charm = $("#charmSearch");

            if (charm.data('hidden') == undefined) {charm.data('hidden', true);}

            if (!charm.data('hidden')) {

                charm.animate({
                    right: -300
                });

                charm.data('hidden', true);
            } else {
                charm.animate({
                    right: 0
                });
                charm.data('hidden', false);
            }
        }

        function showSettings(){
            var  charm = $("#charmSettings");

            if (charm.data('hidden') == undefined) {charm.data('hidden', true);}

            if (!charm.data('hidden')) {

                charm.animate({
                    right: -300
                });

                charm.data('hidden', true);
            } else {
                charm.animate({
                    right: 0
                });
                charm.data('hidden', false);
            }
        }

        function setSearchPlace(el){
            var a = $(el);
            var text = a.text();
            var toggle = a.parents('label').children('.dropdown-toggle');

            toggle.text(text);
        }

        $(function(){
            var current_tile_area_scheme = localStorage.getItem('tile-area-scheme') || "tile-area-scheme-dark";
            $(".tile-area").removeClass (function (index, css) {
                return (css.match (/(^|\s)tile-area-scheme-\S+/g) || []).join(' ');
            }).addClass(current_tile_area_scheme);

            $(".schemeButtons .button").hover(
                    function(){
                        var b = $(this);
                        var scheme = "tile-area-scheme-" +  b.data('scheme');
                        $(".tile-area").removeClass (function (index, css) {
                            return (css.match (/(^|\s)tile-area-scheme-\S+/g) || []).join(' ');
                        }).addClass(scheme);
                    },
                    function(){
                        $(".tile-area").removeClass (function (index, css) {
                            return (css.match (/(^|\s)tile-area-scheme-\S+/g) || []).join(' ');
                        }).addClass(current_tile_area_scheme);
                    }
            );

            $(".schemeButtons .button").on("click", function(){
                var b = $(this);
                var scheme = "tile-area-scheme-" +  b.data('scheme');

                $(".tile-area").removeClass (function (index, css) {
                    return (css.match (/(^|\s)tile-area-scheme-\S+/g) || []).join(' ');
                }).addClass(scheme);

                current_tile_area_scheme = scheme;
                localStorage.setItem('tile-area-scheme', scheme);

                showSettings();
            });
        });
    </script>

</head>
<body>
    <div class="charm right-side padding20 bg-grayDark" id="charmSearch">
        <button class="square-button bg-transparent fg-white no-border place-right small-button" onclick="showSearch()"><span class="mif-cross"></span></button>
        <h1 class="text-light">Search</h1>
        <hr class="thin"/>
        <br />
        <div class="input-control text full-size">
            <label>
                <span class="dropdown-toggle drop-marker-light">Anywhere</span>
                <ul class="d-menu" data-role="dropdown">
                    <li><a onclick="setSearchPlace(this)">Anywhere</a></li>
                    <li><a onclick="setSearchPlace(this)">Options</a></li>
                    <li><a onclick="setSearchPlace(this)">Files</a></li>
                    <li><a onclick="setSearchPlace(this)">Internet</a></li>
                </ul>
            </label>
            <input type="text">
            <button class="button"><span class="mif-search"></span></button>
        </div>
    </div>

    <div class="charm right-side padding20 bg-grayDark" id="charmSettings">
        <button class="square-button bg-transparent fg-white no-border place-right small-button" onclick="showSettings()"><span class="mif-cross"></span></button>
        <h1 class="text-light">Settings</h1>
        <hr class="thin"/>
        <br />
        <div class="schemeButtons">
            <div class="button square-button tile-area-scheme-dark" data-scheme="dark"></div>
            <div class="button square-button tile-area-scheme-darkBrown" data-scheme="darkBrown"></div>
            <div class="button square-button tile-area-scheme-darkCrimson" data-scheme="darkCrimson"></div>
            <div class="button square-button tile-area-scheme-darkViolet" data-scheme="darkViolet"></div>
            <div class="button square-button tile-area-scheme-darkMagenta" data-scheme="darkMagenta"></div>
            <div class="button square-button tile-area-scheme-darkCyan" data-scheme="darkCyan"></div>
            <div class="button square-button tile-area-scheme-darkCobalt" data-scheme="darkCobalt"></div>
            <div class="button square-button tile-area-scheme-darkTeal" data-scheme="darkTeal"></div>
            <div class="button square-button tile-area-scheme-darkEmerald" data-scheme="darkEmerald"></div>
            <div class="button square-button tile-area-scheme-darkGreen" data-scheme="darkGreen"></div>
            <div class="button square-button tile-area-scheme-darkOrange" data-scheme="darkOrange"></div>
            <div class="button square-button tile-area-scheme-darkRed" data-scheme="darkRed"></div>
            <div class="button square-button tile-area-scheme-darkPink" data-scheme="darkPink"></div>
            <div class="button square-button tile-area-scheme-darkIndigo" data-scheme="darkIndigo"></div>
            <div class="button square-button tile-area-scheme-darkBlue" data-scheme="darkBlue"></div>
            <div class="button square-button tile-area-scheme-lightBlue" data-scheme="lightBlue"></div>
            <div class="button square-button tile-area-scheme-lightTeal" data-scheme="lightTeal"></div>
            <div class="button square-button tile-area-scheme-lightOlive" data-scheme="lightOlive"></div>
            <div class="button square-button tile-area-scheme-lightOrange" data-scheme="lightOrange"></div>
            <div class="button square-button tile-area-scheme-lightPink" data-scheme="lightPink"></div>
            <div class="button square-button tile-area-scheme-grayed" data-scheme="grayed"></div>
        </div>
    </div>

    <div class="tile-area tile-area-scheme-dark fg-white">
        <h1 class="tile-area-title">Start</h1>
        <div class="tile-area-controls">
            <button class="image-button icon-right bg-transparent fg-white bg-hover-dark no-border"><span class="sub-header no-margin text-light">Sergey Pimenov</span> <span class="icon mif-user"></span></button>
            <button class="square-button bg-transparent fg-white bg-hover-dark no-border" onclick="showSearch()"><span class="mif-search"></span></button>
            <button class="square-button bg-transparent fg-white bg-hover-dark no-border" onclick="showSettings()"><span class="mif-cog"></span></button>
            <a href="../tiles.html" class="square-button bg-transparent fg-white bg-hover-dark no-border"><span class="mif-switch"></span></a>
        </div>

        <div class="tile-group double">
            <span class="tile-group-title">General</span>

            <div class="tile-container">

                <div class="tile bg-indigo fg-white" data-role="tile">
                    <div class="tile-content iconic">
                        <span class="icon mif-calendar"></span>
                    </div>
                    <span class="tile-label">Calendar</span>
                </div>

                <div class="tile bg-darkBlue fg-white" data-role="tile">
                    <div class="tile-content iconic">
                        <span class="icon mif-envelop"></span>
                    </div>
                    <span class="tile-label">Inbox</span>
                </div>

                <div class="tile-large bg-steel fg-white" data-role="tile">
                    <div class="tile-content" style="background: url(docs/images/clouds2.png) top left no-repeat; background-size: cover">
                        <div class="padding10">
                            <h1>57°</h1>
                            <h2>San Francisco</h2>
                            <h5>Party Cloudy</h5>
                            <p class="tertiary-text fg-white no-margin">Today</p>
                            <p class="tertiary-text fg-white no-margin">63°/55° Mostly Clear</p>
                            <p class="tertiary-text fg-white no-margin">Tomorrow</p>
                            <p class="tertiary-text fg-white no-margin">64°/54° Mostly Clear</p>
                        </div>
                    </div>
                    <span class="tile-label">Weather</span>
                </div>
            </div>
        </div>

        <div class="tile-group double">
            <span class="tile-group-title">Images</span>
            <div class="tile-container">
                <div class="tile-wide" data-role="tile" data-effect="slideLeft">
                    <div class="tile-content">
                        <div class="live-slide"><img src="docs/images/1.jpg" data-role="fitImage" data-format="fill"></div>
                        <div class="live-slide"><img src="docs/images/2.jpg" data-role="fitImage" data-format="fill"></div>
                        <div class="live-slide"><img src="docs/images/3.jpg" data-role="fitImage" data-format="fill"></div>
                        <div class="live-slide"><img src="docs/images/4.jpg" data-role="fitImage" data-format="fill"></div>
                        <div class="live-slide"><img src="docs/images/5.jpg" data-role="fitImage" data-format="fill"></div>
                    </div>
                    <div class="tile-label">Gallery</div>
                </div>
                <div class="tile" data-role="tile" data-role="tile" data-effect="slideUpDown">
                    <div class="tile-content">
                        <div class="live-slide"><img src="docs/images/me.jpg" data-role="fitImage" data-format="fill"></div>
                        <div class="live-slide"><img src="docs/images/spface.jpg" data-role="fitImage" data-format="fill"></div>
                    </div>
                    <div class="tile-label">Photos</div>
                </div>
                <div class="tile-small bg-amber fg-white" data-role="tile">
                    <div class="tile-content iconic">
                        <span class="icon mif-video-camera"></span>
                    </div>
                </div>
                <div class="tile-small bg-green fg-white" data-role="tile">
                    <div class="tile-content iconic">
                        <span class="icon mif-gamepad"></span>
                    </div>
                </div>
                <div class="tile-small bg-pink fg-white" data-role="tile">
                    <div class="tile-content iconic">
                        <span class="icon mif-headphones"></span>
                    </div>
                </div>
                <div class="tile-small bg-yellow fg-white" data-role="tile">
                    <div class="tile-content iconic">
                        <span class="icon mif-lock"></span>
                    </div>
                </div>

                <div class="tile-wide bg-orange fg-white" data-role="tile">
                    <div class="tile-content image-set">
                        <img src="docs/images/jeki_chan.jpg">
                        <img src="docs/images/shvarcenegger.jpg">
                        <img src="docs/images/vin_d.jpg">
                        <img src="docs/images/jolie.jpg">
                        <img src="docs/images/jek_vorobey.jpg">
                    </div>
                </div>

            </div>
        </div>

        <div class="tile-group one">
            <span class="tile-group-title">Office</span>

            <div class="tile-small bg-blue" data-role="tile">
                <div class="tile-content iconic">
                    <img src="docs/images/outlook.png" class="icon">
                </div>
            </div>
            <div class="tile-small bg-darkBlue" data-role="tile">
                <div class="tile-content iconic">
                    <img src="docs/images/word.png" class="icon">
                </div>
            </div>
            <div class="tile-small bg-green" data-role="tile">
                <div class="tile-content iconic">
                    <img src="docs/images/excel.png" class="icon">
                </div>
            </div>
            <div class="tile-small bg-red" data-role="tile">
                <div class="tile-content iconic">
                    <img src="docs/images/access.png" class="icon">
                </div>
            </div>
            <div class="tile-small bg-orange" data-role="tile">
                <div class="tile-content iconic">
                    <img src="docs/images/powerpoint.png" class="icon">
                </div>
            </div>
        </div>

        <div class="tile-group double">
            <span class="tile-group-title">Games</span>
            <div class="tile-container">
                <div class="tile" data-role="tile">
                    <div class="tile-content">
                        <img src="docs/images/grid2.jpg" data-role="fitImage" data-format="square">
                    </div>
                </div>
                <div class="tile-small" data-role="tile">
                    <div class="tile-content">
                        <img src="docs/images/Battlefield_4_Icon.png" data-role="fitImage" data-format="square">
                    </div>
                </div>
                <div class="tile-small" data-role="tile">
                    <div class="tile-content">
                        <img src="docs/images/Crysis-2-icon.png" data-role="fitImage" data-format="square" data-frame-color="bg-steel">
                    </div>
                </div>
                <div class="tile-small" data-role="tile">
                    <div class="tile-content">
                        <img src="docs/images/WorldofTanks.png" data-role="fitImage" data-format="square" data-frame-color="bg-dark">
                    </div>
                </div>
                <div class="tile-small" data-role="tile">
                    <div class="tile-content">
                        <img src="docs/images/halo.jpg" data-role="fitImage" data-format="square">
                    </div>
                </div>
                <div class="tile-wide bg-green fg-white" data-role="tile">
                    <div class="tile-content iconic">
                        <img src="docs/images/x-box.png" class="icon">
                    </div>
                    <div class="tile-label">X-Box Live</div>
                </div>
            </div>
        </div>

        <div class="tile-group double">
            <span class="tile-group-title">Other</span>
            <div class="tile-container">
                <div class="tile bg-teal fg-white" data-role="tile">
                    <div class="tile-content iconic">
                        <span class="icon mif-pencil"></span>
                    </div>
                    <span class="tile-label">Editor</span>
                </div>
                <div class="tile bg-darkGreen fg-white" data-role="tile">
                    <div class="tile-content iconic">
                        <span class="icon mif-shopping-basket"></span>
                    </div>
                    <span class="tile-label">Store</span>
                </div>
                <div class="tile bg-cyan fg-white" data-role="tile">
                    <div class="tile-content iconic">
                        <span class="icon mif-skype"></span>
                    </div>
                    <div class="tile-label">Skype</div>
                </div>
                <div class="tile bg-darkBlue fg-white" data-role="tile">
                    <div class="tile-content iconic">
                        <span class="icon mif-cloud"></span>
                    </div>
                    <span class="tile-label">OneDrive</span>
                </div>
            </div>
        </div>
    </div>

    <!-- hit.ua -->
    <a href='http://hit.ua/?x=136046' target='_blank'>
        <script language="javascript" type="text/javascript"><!--
        Cd=document;Cr="&"+Math.random();Cp="&s=1";
        Cd.cookie="b=b";if(Cd.cookie)Cp+="&c=1";
        Cp+="&t="+(new Date()).getTimezoneOffset();
        if(self!=top)Cp+="&f=1";
        //--></script>
        <script language="javascript1.1" type="text/javascript"><!--
        if(navigator.javaEnabled())Cp+="&j=1";
        //--></script>
        <script language="javascript1.2" type="text/javascript"><!--
        if(typeof(screen)!='undefined')Cp+="&w="+screen.width+"&h="+
        screen.height+"&d="+(screen.colorDepth?screen.colorDepth:screen.pixelDepth);
        //--></script>
        <script language="javascript" type="text/javascript"><!--
        Cd.write("<img src='http://c.hit.ua/hit?i=136046&g=0&x=2"+Cp+Cr+
        "&r="+escape(Cd.referrer)+"&u="+escape(window.location.href)+
        "' border='0' wi"+"dth='1' he"+"ight='1'/>");
        //--></script></a>
    <!-- / hit.ua -->


</body>
</html>