
<?php
include 'dp.php'; // database connection

if (!isset($_POST['message'])) {
    echo "\u26d4\ufe0f Message not received!";
    exit;
}

$userMsg = strtolower(trim($_POST['message']));
$userMsg = preg_replace("/[^a-z0-9\s]+/", "", $userMsg);
$words = explode(" ", $userMsg);

// Full ignore word list
$ignoreWords = [
    'ka','ki','ke','kaun','kon','kis','kiska','kiski','kiske','kya','kia','kyun','kab','kahan','kisne','kisi','kidar','batao','rate','price','cost','chahiye','kitna','kitne','send','please','plz','plzz','plsss','show','detail','details','hai','hy','hai?','ha','haan','hona','hota','hogya','hogai','raha','rahe','rhi','rha','kr','kar','karo','krdo','de','dede','dena','dekar','dijiye','diya','chahiye','len','lo','lenge','mujhe','muje','main','mein','me','mera','meri','meray','apka','aapka','tumhara','your','you','i','want','need','can','will','do','does','did','should','would','could','have','has','had','am','are','is','was','were','been','being','kindly','thanks','thank','thanx','welcome','hello','hi','salam','bhai','sir','madam','team','admin','boss','owner','friend','buddy','manager','support','help','assistance','call','contact','whatsapp','number','time','again','soon','quick','delivery','pickup','status','waiting','check','confirm','open','close','timing','working','hours','days','address','area','city','village','location','shop','store','market','road','street','block','plot','building','direction','map','landmark','no','yes','ok','okay','fine','great','awesome','nice','jazakallah','regards','walaikum','wassalam','asalamualaikum','aslamualaikum','yahan','idhar','udhar','wahan','part','product','item','things','thing','stuff','equipment','material','goods','pieces','per','par','of','or','ya','aur','se','ko','in','on','to','the','an','a'
];

$filtered = array_filter($words, function($w) use ($ignoreWords) {
    return $w !== "" && !in_array($w, $ignoreWords);
});

$filtered = array_map(function($w) use ($conn) {
    return $conn->real_escape_string(trim($w));
}, $filtered);

if (empty($filtered)) {
    echo "📜 Shayad aapka message sirf general lafzon per mabni hai.\n";
    echo "Zara part ka naam ya part number dobara bhejein.\n\n";
    echo "📜 It seems your message only includes general words.\n";
    echo "Please resend with product name or part number.";
    exit;
}

// Fetch all data columns for intelligent matching
$allModels = $conn->query("SELECT DISTINCT LOWER(Model) as val FROM gd_product");
$allMakers = $conn->query("SELECT DISTINCT LOWER(Maker) as val FROM gd_product");
$allDescriptions = $conn->query("SELECT DISTINCT LOWER(Description) as val FROM gd_product");
$allSizes = $conn->query("SELECT DISTINCT LOWER(Size) as val FROM gd_product WHERE Size IS NOT NULL AND Size != ''");

$modelList = $makerList = $descList = $sizeList = [];
while ($row = $allModels->fetch_assoc()) $modelList[] = $row['val'];
while ($row = $allMakers->fetch_assoc()) $makerList[] = $row['val'];
while ($row = $allDescriptions->fetch_assoc()) $descList[] = $row['val'];
while ($row = $allSizes->fetch_assoc()) $sizeList[] = $row['val'];

$models = $makers = $descs = $sizes = $partnos = [];

foreach ($filtered as $word) {
    if (in_array($word, $modelList)) {
        $models[] = $word;
    } elseif (in_array($word, $makerList)) {
        $makers[] = $word;
    } elseif (in_array($word, $descList)) {
        $descs[] = $word;
    } elseif (in_array($word, $sizeList)) {
        $sizes[] = $word;
    } elseif (is_numeric($word)) {
        $partnos[] = $word;
    }
}

$conditions = [];
if (!empty($partnos)) {
    $partConditions = array_map(function($p) {
        return "Partno LIKE '%$p%'";
    }, $partnos);
    $conditions[] = '(' . implode(' OR ', $partConditions) . ')';
}
if (!empty($models)) {
    $modelConditions = array_map(function($m) {
        return "LOWER(Model) LIKE '%$m%'";
    }, $models);
    $conditions[] = '(' . implode(' OR ', $modelConditions) . ')';
}
if (!empty($makers)) {
    $makerConditions = array_map(function($b) {
        return "LOWER(Maker) LIKE '%$b%'";
    }, $makers);
    $conditions[] = '(' . implode(' OR ', $makerConditions) . ')';
}
if (!empty($descs)) {
    $descConditions = array_map(function($d) {
        return "LOWER(Description) LIKE '%$d%'";
    }, $descs);
    $conditions[] = '(' . implode(' OR ', $descConditions) . ')';
}
if (!empty($sizes)) {
    $sizeConditions = array_map(function($s) {
        return "LOWER(Size) LIKE '%$s%'";
    }, $sizes);
    $conditions[] = '(' . implode(' OR ', $sizeConditions) . ')';
}

if (empty($conditions)) {
    echo "❌ Maazrat, koi relevant item nahi mila.\n";
    echo "Zara asaan aur mukammal tareeqe se part ka naam ya number likhein.\n\n";
    echo "❌ Sorry, we couldn't find a matching product.\n";
    echo "Please try using the full and correct product name or part number.";
}

$whereClause = implode(" AND ", $conditions);
$sql = "SELECT * FROM gd_product WHERE $whereClause and Brand='tpr' LIMIT 10";
$result = $conn->query($sql);

if ($result->num_rows === 0) {
    echo "❌ Maazrat, koi relevant item nahi mila.\n";
    echo "Zara asaan aur mukammal tareeqe se part ka naam ya number likhein.\n\n";
    echo "❌ Sorry, we couldn't find a matching product.\n";
    echo "Please try using the full and correct product name or part number.";
}


$i = 1;
echo "✅ Aap ke liye matching products yeh rahe:\n";
while ($row = $result->fetch_assoc()) {
    echo "\n🔹 *Product #$i*";
    echo "\n📦 *Part#:* {$row['Partno']}";
    echo "\n🚗 *Model:* {$row['Maker']} {$row['Model']}";
    echo "\n📝 *Description:* {$row['Description']}";
    if (!empty($row['Size'])) echo "\n📏 *Size:* {$row['Size']}";
    echo "\n💰 *Price:* Rs. {$row['Price']}";
    echo "\n────────────────────────────";
    $i++;
}


