<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Auto Parts Chatbot</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

  <style>
    body {
      background: #0d1117;
      color: #c9d1d9;
      font-family: Arial, sans-serif;
    }
    .chatbox {
      max-width: 700px;
      margin: 30px auto;
      background: #161b22;
      border: 1px solid #30363d;
      border-radius: 10px;
      display: flex;
      flex-direction: column;
      height: 85vh;
    }

    .chat-header {

      padding: 15px;
      font-size: 18px;
      font-weight: bold;
background: #21262d;
      border-bottom: 1px solid #30363d;
    }

    .chat-messages {
      flex: 1;
      overflow-y: auto;
      padding: 20px;
    }
    .message {
      margin-bottom: 15px;
    }
    .user-message {
      text-align: right;
    }
    .user-message .msg {
      background: #238636;
      color: white;
      display: inline-block;
      padding: 10px 15px;
      border-radius: 15px 15px 0 15px;
      max-width: 80%;
    }
    .bot-message .msg {
      background: #30363d;
      color: #d1d5da;
      display: inline-block;
      padding: 10px 15px;
      border-radius: 15px 15px 15px 0;
      max-width: 80%;
    }

    .input-container {
      background: #21262d;
      padding: 10px 15px;
      display: flex;
      align-items: center;
      border-top: 1px solid #30363d;
      border-radius: 0 0 10px 10px;
    }

    .input-btn {
      background: none;
      border: none;
      color: #8b949e;
      font-size: 20px;
      margin-right: 10px;
    }

    #userInput {
      flex: 1;
      background: transparent;
      border: none;
      color: white;
      padding: 10px;
      resize: none;
      outline: none;
      font-size: 15px;
    }

    .send-btn {
      background: #238636;
      border: none;
      color: white;
      padding: 8px 15px;
      border-radius: 6px;
    }

    ::placeholder {
      color: #8b949e;
    }

    .chat-messages::-webkit-scrollbar {
      width: 6px;
    }
    .chat-messages::-webkit-scrollbar-thumb {
      background: #444c56;
      border-radius: 10px;
    }
  </style>
</head>
<body>

<div class="chatbox shadow">
  <div class="chat-header">🛠 AUTO PARTS CHATBOT</div>

  <div class="chat-messages" id="chatMessages">
    <!-- Messages will be shown here -->
  </div>

  <form id="chatForm" class="input-container">
    <button type="button" class="input-btn">+</button>
    <textarea id="userInput" rows="1" placeholder="Ask anything..." autofocus></textarea>
    <button type="submit" class="send-btn">Send</button>
  </form>
</div>

<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script>
  function showTypingEffect(text, container, delay = 50) {
    let lines = text.split('\n');
    let currentLine = 0;

    function typeNextLine() {
      if (currentLine < lines.length) {
        const lineDiv = $('<div>').html(lines[currentLine]);
        container.append(lineDiv);
        container.scrollTop(container[0].scrollHeight);
        currentLine++;
        setTimeout(typeNextLine, delay);
      }
    }

    typeNextLine();
  }

  function sendMessage() {
    let msg = $('#userInput').val().trim();
    if (msg === '') return;

    // Show user message
    $('#chatMessages').append(`
      <div class="message user-message">
        <div class="msg">${msg}</div>
      </div>
    `);
    $('#userInput').val('');
    $('#chatMessages').scrollTop($('#chatMessages')[0].scrollHeight);

    // Bot typing...
    const botMsgDiv = $(`
      <div class="message bot-message">
        <div class="msg"><em>🔎 Searching...</em></div>
      </div>
    `);
    $('#chatMessages').append(botMsgDiv);
    $('#chatMessages').scrollTop($('#chatMessages')[0].scrollHeight);

    // Fetch response from server
    $.post('chatbot.php', { message: msg }, function(response) {
      // After 2 seconds, replace "Searching..." with typed message
      setTimeout(function () {
        botMsgDiv.find('.msg').html(''); // Clear previous "Searching..." message
        showTypingEffect(response, botMsgDiv.find('.msg'), 100);
      }, 2000);
    });
  }

  $('#chatForm').on('submit', function(e) {
    e.preventDefault();
    sendMessage();
  });

  $('#userInput').on('keypress', function(e) {
    if (e.which === 13 && !e.shiftKey) {
      e.preventDefault();
      sendMessage();
    }
  });
</script>


</body>
</html>
