<?php
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
  header('Content-Disposition: attachment;filename="graph.xlsx"');
  header('Cache-Control: max-age=0');

  include_once 'PHPExcel.php';
  $phpexcel = new PHPExcel();

  $phpexcel->setActiveSheetIndex(0);
  $sheet = $phpexcel->getActiveSheet();

  $data = array('20', '31', '50', '80', '105', '139', '180', 'k', '256', '308','359','405','449','491','516');
  $row = 1;
  foreach($data as $point) {
    $sheet->setCellValueByColumnAndRow(1, $row++, $point);
  }

  $data = array('20', '31', '50', '80', '105', '139', '180', '219', '256', '308','359','405','449','491','516');
  $row = 1;
  foreach($data as $point) {
    $sheet->setCellValueByColumnAndRow(0, $row++, $point);
  }

  $values = new PHPExcel_Chart_DataSeriesValues('Number', 'Worksheet!$B$1:$B$10');
  $categories = new PHPExcel_Chart_DataSeriesValues('String', 'Worksheet!$A$1:$A$10');

  $series = new PHPExcel_Chart_DataSeries(
    PHPExcel_Chart_DataSeries::TYPE_AREACHART,       // plotType
    PHPExcel_Chart_DataSeries::GROUPING_CLUSTERED,  // plotGrouping
    array(0),                                       // plotOrder
    array(),                                        // plotLabel
    array($categories),                             // plotCategory
    array($values)                                  // plotValues
  );
  $series->setPlotDirection(PHPExcel_Chart_DataSeries::DIRECTION_VERTICAL);

  $layout = new PHPExcel_Chart_Layout();
  $plotarea = new PHPExcel_Chart_PlotArea($layout, array($series));
  $xTitle = new PHPExcel_Chart_Title('xAxisLabel');
  $yTitle = new PHPExcel_Chart_Title('yAxisLabel');

  $chart = new PHPExcel_Chart('sample', null, null, $plotarea, true,0,$xTitle,$yTitle);

  $chart->setTopLeftPosition('C1');
  $chart->setBottomRightPosition('J15');

  $sheet->addChart($chart);

  $writer = PHPExcel_IOFactory::createWriter($phpexcel, 'Excel2007');
  $writer->setIncludeCharts(TRUE);
  $writer->save('php://output');
  
  ?>